<?php
/*
  Plugin Name: News
  Plugin URI: https://wordpress.org/themes/twentysixteen/
  Description: Twenty Sixteen is a modernized take on an ever-popular WordPress layout — the horizontal masthead with an optional right sidebar that works perfectly for blogs and websites. It has custom color options with beautiful default color schemes, a harmonious fluid grid using a mobile-first approach, and impeccable polish in every detail. Twenty Sixteen will make your WordPress look beautiful everywhere.
Version: 1.3
  Version: 1.3
  Author: Snehal Vanjari
  Author URI: http://twitter.com/hiddenpearls
  License: GPLv2+
  Text Domain: twentysixteen
*/

class news_widget extends WP_Widget {

function __construct() {
parent::__construct(
// Base ID of your widget
'news_widget', 

// Widget name will appear in UI
__('Past News add', 'event_widget_domain'), 

// Widget description
array( 'description' => __( 'Widget based on showing event', 'event_widget_domain' ), ) 
);
}

// Creating widget front-end


// This is where the action happens
public function widget( $args, $instance ) {
$title = apply_filters( 'widget_title', $instance['title'] );
// before and after widget arguments are defined by themes
echo $args['before_widget'];
if ( have_posts())
echo $args['before_title'] . $title . $args['after_title'];
?>
<div class="follow-email-box">

<ul class="popular-post-block">

<?php 


$d = date("Y-m-d");
$date = the_date();
//$args = array(
    //'post_type'         => 'news', 
    //'meta_key'          => 'event_date',
    //'orderby'           => 'meta_value_num',
    //'order'             => 'ASC',
    //'posts_per_page'    => 5,
    //'meta_query'        => array(
        //array(
            //'key' => 'event_date',
            //'value' => $d,
            //'type' => 'date',
            //'compare' => '<'
        //)
    //)
//);
$args = array(
    'post_type'         => 'news', 
    'orderby'           => 'date',
    'order'             => 'ASC',
    'posts_per_page'    => 5,
    
);


$the_query = new WP_Query($args); 

		//print_r($args);						
?>
						
								
<?php while ($the_query -> have_posts()) : $the_query -> the_post(); 
?>
	
		 <li>
			<div class="item-thumbnail-only">
				<div class="item-thumbnail">
					<?php the_post_thumbnail() ?>
				</div>
				<div class="item-title"><?php the_title ()?></div>
					
			</div>
			<div style="clear: both;"></div>
		 </li>

<?php 
endwhile;
wp_reset_postdata();
?>
</ul>
</div>
<?php
echo $args['after_widget'];
}
		
// Widget Backend 
public function form( $instance ) {
if ( isset( $instance[ 'title' ] ) ) {
$title = $instance[ 'title' ];
}
else {
$title = __( 'New title', 'event_widget_domain' );
}
// Widget admin form
?>
<p>
<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' ); ?></label> 
<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />

</p>
<?php 
}
	
// Updating widget replacing old instances with new
public function update( $new_instance, $old_instance ) {
$instance = array();
$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
return $instance;
}
} // Class wpb_widget ends here

// Register and load the widget
function load_widget() {
	register_widget( 'news_widget' );
}
add_action( 'widgets_init', 'load_widget' );



//added code new

// Enable shortcodes in text widgets
add_filter('widget_text', 'do_shortcode');

?>
