<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Seventeen
 * @since 1.0
 * @version 1.0
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?> itemscope itemtype="http://schema.org/WebPage" class="no-js no-svg">
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1"/>
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="icon" href="<?php echo get_template_directory_uri(); ?>/assets/images/favicon.ico" type="image/x-icon" />
<link href="<?php echo get_template_directory_uri(); ?>/assets/css/style.css" rel="stylesheet" type="text/css"  />
<link href="https://fonts.googleapis.com/css?family=Exo+2:400,700" rel="stylesheet">
<link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:400,700,900" rel="stylesheet">
<link href="https://fonts.googleapis.com/css?family=Open+Sans" rel="stylesheet">
<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/responsive-slider.css" type="text/css">
<link href="https://fonts.googleapis.com/css?family=Playfair+Display:400i" rel="stylesheet"> 
<!--link href="https://fonts.googleapis.com/css?family=Lobster" rel="stylesheet"-->
<link href="<?php echo get_template_directory_uri(); ?>/assets/css/jquery.newsticker.min.css" rel="stylesheet" type="text/css">
<? if(is_front_page()) { ?>
<link href="<?php echo get_template_directory_uri(); ?>/assets/css/easy-responsive-tabs-home.css" rel="stylesheet" type="text/css" />
<? } else { ?>
<link href="<?php echo get_template_directory_uri(); ?>/assets/css/easy-responsive-tabs.css" rel="stylesheet" type="text/css" />	
<? } ?>	
<link href="<?php echo get_template_directory_uri(); ?>/assets/css/hover.css" rel="stylesheet" media="all">
<link href="<?php echo get_template_directory_uri(); ?>/assets/css/owl.carousel.css" rel="stylesheet">
<link href="<?php echo get_template_directory_uri(); ?>/assets/css/owl.theme.css" rel="stylesheet">
<link href="<?php echo get_template_directory_uri(); ?>/assets/css/slide.css" rel="stylesheet">
<!-- CCS for the effects-->
<link href="<?php echo get_template_directory_uri(); ?>/assets/css/effects.min.css" rel="stylesheet"> 
<!-- CCS for the effects-->
<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/animate.css">
<!-- CCS for the effects-->
<!--mobile menu-->
<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/assets/css/component.css" />

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<div class="top-area">
  <div class="wrapper">
    <div class="logo-area wow fadeInLeft" data-wow-delay="0.1s"> 
		<?php the_custom_logo(); ?>
	</div>
		
	
    <div class="menu-container">
      <div class="top-inside-area wow fadeInRight" data-wow-delay="0.1s">
        
			<?php if ( is_active_sidebar( 'top-right' )  ) : ?>
			 <?php dynamic_sidebar( 'top-right' ); ?>
			<?php endif; ?>
			
       </div>
     
      <div class="menu-area wow fadeInRight" data-wow-delay="0.1s">
        <?php wp_nav_menu( array( 'theme_location' => 'top' ) ); ?>
       
        
        <div class="mobile-menu">
			<div id="dl-menu" class="dl-menuwrapper">
				
			<button class="dl-trigger">Menu</button>
			  <!--ul class=""-->
				 <?php wp_nav_menu( array(
												'container'=> false,	
												'theme_location' => 'mobile-menu',
												'menu_class'     => 'mobile-menu1 dl-menu',
				 ) ); ?>
			 <!--/ul-->
			</div>
			</div>
        
        
        <div class="search-area">
          
          <?php if ( is_active_sidebar( 'search' )  ) : ?>
			 <?php dynamic_sidebar( 'search' ); ?>
			<?php endif; ?>
        </div>
        
      </div>
    </div>
  </div>
</div>

<div class="slide-out-div1"> 
	<a href="javascript:void(0)" class="handle1">&nbsp;</a> 
  <div class="contact-form">
   <?php echo do_shortcode('[contact-form-7 id="244" title="Enquire form"]'); ?>
  </div>
</div>

<div class="slide-out-div1-1"> <a href="javascript:void(0)" class="handle1-1">&nbsp;</a> 
  <div class="contact-form">
    <?php echo do_shortcode('[contact-form-7 id="244" title="Enquire form"]'); ?>
  </div>
</div>
	
<div class="slide-out-div4"><a href="<?php echo home_url();?>/calculator"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/calculator-btn.png" alt=""  /></a></div>

<div class="slide-out-div5"><a href="<?php echo home_url();?>/calculator"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/calculator-btn2.png" alt=""  /></a></div>


<script type="text/javascript">
   
	jQuery(document).ready(function () {
    jQuery('.slide-out-div1').css('display', 'block');
	});
</script>
