<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package WordPress
 * @subpackage Twenty_Seventeen
 * @since 1.0
 * @version 1.0
 */

get_header(); ?>
<div class="inside-header-news"> 
</div>

<div class="header-bottom-area2">
	<div class="breadcrumb-area"> 
		<div class="wrapper">
			<div class="breadcrumb-area" typeof="BreadcrumbList" vocab="https://schema.org/"> 
				<?php if(function_exists('bcn_display'))
				{
				bcn_display();
				}?>

			</div>
		</div>
	</div>
</div>

<div class="wrapper">
 <div class="main-content">
	<div class="left-panel">
			<?php
				/* Start the Loop */
				while ( have_posts() ) : the_post();

					get_template_part( 'template-parts/post/content-news-single', get_post_format() );

					// If comments are open or we have at least one comment, load up the comment template.
					if ( comments_open() || get_comments_number() ) :
						comments_template();
					endif;

					the_post_navigation( array(
						'prev_text' => '<span class="screen-reader-text">' . __( 'Previous Post', 'twentyseventeen' ) . '</span><span aria-hidden="true" class="nav-subtitle">' . __( 'Previous', 'twentyseventeen' ) . '</span> <span class="nav-title"><span class="nav-title-icon-wrapper">' . twentyseventeen_get_svg( array( 'icon' => 'arrow-left' ) ) . '</span>%title</span>',
						'next_text' => '<span class="screen-reader-text">' . __( 'Next Post', 'twentyseventeen' ) . '</span><span aria-hidden="true" class="nav-subtitle">' . __( 'Next', 'twentyseventeen' ) . '</span> <span class="nav-title">%title<span class="nav-title-icon-wrapper">' . twentyseventeen_get_svg( array( 'icon' => 'arrow-right' ) ) . '</span></span>',
					) );

				endwhile; // End of the loop.
			?>
		</div> <!--left panel-->
		
		<div class="right-panel">
			<div class="search">
				<form action="<?php echo home_url()?>" class="search-form" method="get" role="search">
					<label>
						
						<input type="search" name="s" value="" placeholder="Search …" class="search-field">
					</label>
					<input type="submit" value="Search" class="search-submit screen-reader-text">
				</form>
			</div>
			
			<div class="viewed">
			<h3>Most Viewed</h3>
			<?php if ( is_active_sidebar( 'most-viewed' )  ) : ?>
					<?php dynamic_sidebar( 'most-viewed' ); ?>
				<?php endif; ?>
			</div>
			
			<div class="past-news">
				<!--past post-->
				<?php if ( is_active_sidebar( 'past-news' )  ) : ?>
					 <?php dynamic_sidebar( 'past-news' ); ?>
					<?php endif; ?>
				<!--past post end-->
			</div>
			
		</div>
		
	</div><!-- #primary -->
	
</div><!-- .wrap -->

<?php get_footer();
